<?php

namespace App\Models\Involvements;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EpisodeType extends Model 
{

    protected $table = 'episode_types';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getEventFacts()
    {
        return $this->hasMany('Events');
    }

    public function getChallenges()
    {
        return $this->hasMany('Challenge');
    }

    public function getQuizes()
    {
        return $this->hasMany('Quiz');
    }

    public function getActivities()
    {
        return $this->hasMany('Activity');
    }

    public function getInvolvements()
    {
        return $this->belongsToMany('Involvement', 'episode_type_involvement');
    }

}